/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import sleep.engine.Step;
import sleep.interfaces.Variable;
import sleep.runtime.ProxyIterator;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Iterate
extends Step {
    public static final int ITERATOR_CREATE = 1;
    public static final int ITERATOR_DESTROY = 2;
    public static final int ITERATOR_NEXT = 3;
    protected int type = 0;
    protected String key;
    protected String value;

    public String toString(String string) {
        switch (this.type) {
            case 1: {
                return string + "[Create Iterator]\n";
            }
            case 2: {
                return string + "[Destroy Iterator]\n";
            }
            case 3: {
                return string + "[Iterator next]\n";
            }
        }
        return string + "[Iterator Unknown!@]";
    }

    public Iterate(String string, String string2, int n) {
        this.type = n;
        this.key = string;
        this.value = string2;
    }

    private void iterator_destroy(ScriptEnvironment scriptEnvironment) {
        Stack stack = (Stack)scriptEnvironment.getContextMetadata("iterators");
        stack.pop();
    }

    private void iterator_create(ScriptEnvironment scriptEnvironment) {
        Stack stack = scriptEnvironment.getCurrentFrame();
        IteratorData iteratorData = new IteratorData();
        iteratorData.source = (Scalar)stack.pop();
        scriptEnvironment.KillFrame();
        iteratorData.value = this.value;
        iteratorData.venv = scriptEnvironment.getScriptVariables().getScalarLevel(this.value, scriptEnvironment.getScriptInstance());
        if (iteratorData.venv == null) {
            iteratorData.venv = scriptEnvironment.getScriptVariables().getGlobalVariables();
            if ((scriptEnvironment.getScriptInstance().getDebugFlags() & 4) == 4) {
                scriptEnvironment.showDebugMessage("variable '" + iteratorData.value + "' not declared");
            }
        }
        if (this.key != null) {
            iteratorData.key = this.key;
            iteratorData.kenv = scriptEnvironment.getScriptVariables().getScalarLevel(this.key, scriptEnvironment.getScriptInstance());
            if (iteratorData.kenv == null) {
                iteratorData.kenv = scriptEnvironment.getScriptVariables().getGlobalVariables();
                if ((scriptEnvironment.getScriptInstance().getDebugFlags() & 4) == 4) {
                    scriptEnvironment.showDebugMessage("variable '" + iteratorData.key + "' not declared");
                }
            }
        }
        if (iteratorData.source.getHash() != null) {
            iteratorData.iterator = iteratorData.source.getHash().getData().entrySet().iterator();
        } else if (iteratorData.source.getArray() != null) {
            iteratorData.iterator = iteratorData.source.getArray().scalarIterator();
        } else if (SleepUtils.isFunctionScalar(iteratorData.source)) {
            iteratorData.iterator = SleepUtils.getFunctionFromScalar(iteratorData.source, scriptEnvironment.getScriptInstance()).scalarIterator();
        } else if (ProxyIterator.isIterator(iteratorData.source)) {
            iteratorData.iterator = new ProxyIterator((Iterator)iteratorData.source.objectValue(), true);
        } else {
            scriptEnvironment.getScriptInstance().fireWarning("Attempted to use foreach on non-array: '" + iteratorData.source + "'", this.getLineNumber());
            iteratorData.iterator = null;
        }
        Stack<IteratorData> stack2 = (Stack<IteratorData>)scriptEnvironment.getContextMetadata("iterators");
        if (stack2 == null) {
            stack2 = new Stack<IteratorData>();
            scriptEnvironment.setContextMetadata("iterators", stack2);
        }
        stack2.push(iteratorData);
    }

    private void iterator_next(ScriptEnvironment scriptEnvironment) {
        Stack stack = (Stack)scriptEnvironment.getContextMetadata("iterators");
        IteratorData iteratorData = (IteratorData)stack.peek();
        if (iteratorData.iterator == null || !iteratorData.iterator.hasNext()) {
            scriptEnvironment.getCurrentFrame().push(SleepUtils.getScalar(false));
            return;
        }
        scriptEnvironment.getCurrentFrame().push(SleepUtils.getScalar(true));
        Object var4_4 = null;
        try {
            var4_4 = iteratorData.iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            iteratorData.iterator = null;
            throw concurrentModificationException;
        }
        if (iteratorData.source.getHash() != null) {
            if (SleepUtils.isEmptyScalar((Scalar)((Map.Entry)var4_4).getValue())) {
                scriptEnvironment.getCurrentFrame().pop();
                this.iterator_next(scriptEnvironment);
                return;
            }
            if (iteratorData.key != null) {
                iteratorData.kenv.putScalar(iteratorData.key, SleepUtils.getScalar(((Map.Entry)var4_4).getKey()));
                iteratorData.venv.putScalar(iteratorData.value, (Scalar)((Map.Entry)var4_4).getValue());
            } else {
                iteratorData.venv.putScalar(iteratorData.value, SleepUtils.getScalar(((Map.Entry)var4_4).getKey()));
            }
        } else if (iteratorData.key != null) {
            iteratorData.kenv.putScalar(iteratorData.key, SleepUtils.getScalar(iteratorData.count));
            iteratorData.venv.putScalar(iteratorData.value, var4_4);
        } else {
            iteratorData.venv.putScalar(iteratorData.value, var4_4);
        }
        ++iteratorData.count;
    }

    public Scalar evaluate(ScriptEnvironment scriptEnvironment) {
        if (this.type == 3) {
            this.iterator_next(scriptEnvironment);
        } else if (this.type == 1) {
            this.iterator_create(scriptEnvironment);
        } else if (this.type == 2) {
            this.iterator_destroy(scriptEnvironment);
        }
        return null;
    }

    public static class IteratorData {
        public String key = null;
        public Variable kenv = null;
        public String value = null;
        public Variable venv = null;
        public Scalar source = null;
        public Iterator iterator = null;
        public int count = 0;
    }
}

