/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.types;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.SleepClosure;
import sleep.engine.types.HashContainer;
import sleep.runtime.CollectionWrapper;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.SleepUtils;

public class OrderedHashContainer
extends HashContainer {
    protected boolean shouldClean = false;
    protected SleepClosure missPolicy;
    protected SleepClosure removalPolicy;

    public OrderedHashContainer(int n, float f, boolean bl) {
        this.values = new OrderedHash(n, f, bl);
    }

    public void setRemovalPolicy(SleepClosure sleepClosure) {
        this.removalPolicy = sleepClosure;
    }

    public void setMissPolicy(SleepClosure sleepClosure) {
        this.missPolicy = sleepClosure;
    }

    protected boolean removeEldestEntryCheck(Map.Entry entry) {
        if (this.removalPolicy != null && entry != null) {
            Stack<Object> stack = new Stack<Object>();
            stack.push(entry.getValue());
            stack.push(SleepUtils.getScalar(entry.getKey().toString()));
            stack.push(SleepUtils.getHashScalar(this));
            Scalar scalar = this.removalPolicy.callClosure("remove", null, stack);
            return SleepUtils.isTrueScalar(scalar);
        }
        return false;
    }

    public ScalarArray keys() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.values.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (SleepUtils.isEmptyScalar((Scalar)entry.getValue())) continue;
            linkedList.add(entry.getKey());
        }
        this.shouldClean = this.values.size() > linkedList.size() + 1;
        return new CollectionWrapper(linkedList);
    }

    private void cleanup() {
        if (this.shouldClean) {
            Iterator iterator = this.values.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!SleepUtils.isEmptyScalar((Scalar)entry.getValue())) continue;
                iterator.remove();
            }
            this.shouldClean = false;
        }
    }

    public Scalar getAt(Scalar scalar) {
        String string = ((Object)scalar.getValue()).toString();
        Scalar scalar2 = (Scalar)this.values.get(string);
        if (this.missPolicy != null && SleepUtils.isEmptyScalar(scalar2)) {
            this.cleanup();
            Stack<Scalar> stack = new Stack<Scalar>();
            stack.push(scalar);
            stack.push(SleepUtils.getHashScalar(this));
            scalar2 = this.missPolicy.callClosure("miss", null, stack);
            this.values.put(string, scalar2);
        } else if (scalar2 == null) {
            this.cleanup();
            scalar2 = SleepUtils.getEmptyScalar();
            this.values.put(string, scalar2);
        }
        return scalar2;
    }

    private class OrderedHash
    extends LinkedHashMap {
        public OrderedHash(int n, float f, boolean bl) {
            super(n, f, bl);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return OrderedHashContainer.this.removeEldestEntryCheck(entry);
        }
    }
}

