/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.util.Iterator;
import sleep.parser.LexicalAnalyzer;
import sleep.parser.Parser;
import sleep.parser.StringIterator;
import sleep.parser.Token;
import sleep.parser.TokenList;

public class ParserUtilities {
    public static Token combineTokens(Token token, Token token2) {
        return new Token(token.toString() + token2.toString(), token.getHint());
    }

    public static Token makeToken(String string, Token token) {
        return new Token(string, token.getHint());
    }

    public static Token[] get(Token[] tokenArray, int n, int n2) {
        Token[] tokenArray2 = new Token[n2 - n];
        for (int i = 0; i < tokenArray2.length; ++i) {
            tokenArray2[i] = tokenArray[n + i];
        }
        return tokenArray2;
    }

    public static Token join(Token[] tokenArray) {
        return ParserUtilities.join(tokenArray, " ");
    }

    public static Token join(Token[] tokenArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < tokenArray.length; ++i) {
            if (i > 0 && tokenArray[i].getHint() == tokenArray[i - 1].getTopHint() || i == 0) {
                stringBuffer.append(string);
            } else {
                int n = tokenArray[i].getHint() - tokenArray[i - 1].getTopHint();
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append("\n");
                }
            }
            stringBuffer.append(tokenArray[i].toString());
        }
        return new Token(stringBuffer.toString(), tokenArray[0].getHint());
    }

    public static Token extract(Token token) {
        return new Token(ParserUtilities.extract(token.toString()), token.getHint());
    }

    public static String extract(String string) {
        return string.substring(1, string.length() - 1);
    }

    public static TokenList groupByBlockTerm(Parser parser, Token token) {
        StringIterator stringIterator = new StringIterator(token.toString(), token.getHint());
        TokenList tokenList = LexicalAnalyzer.GroupBlockTokens(parser, stringIterator);
        return ParserUtilities.groupByTerm(tokenList);
    }

    public static TokenList groupByMessageTerm(Parser parser, Token token) {
        StringIterator stringIterator = new StringIterator(token.toString(), token.getHint());
        TokenList tokenList = LexicalAnalyzer.GroupExpressionIndexTokens(parser, stringIterator);
        return ParserUtilities.groupByTerm(tokenList);
    }

    public static TokenList groupByParameterTerm(Parser parser, Token token) {
        StringIterator stringIterator = new StringIterator(token.toString(), token.getHint());
        TokenList tokenList = LexicalAnalyzer.GroupParameterTokens(parser, stringIterator);
        return ParserUtilities.groupByTerm(tokenList);
    }

    private static TokenList groupByTerm(TokenList tokenList) {
        TokenList tokenList2 = new TokenList();
        if (tokenList.getList().size() == 0) {
            return tokenList2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        Iterator iterator = tokenList.getList().iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            int n2 = n = n == -1 ? token.getHint() : n;
            if (token.toString().equals("EOT")) {
                tokenList2.add(new Token(stringBuffer.toString(), n));
                stringBuffer = new StringBuffer();
                n = -1;
                continue;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(token.toString());
        }
        if (stringBuffer.length() > 0) {
            tokenList2.add(new Token(stringBuffer.toString(), n));
        }
        return tokenList2;
    }
}

