/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import text.AttributedString;
import text.AttributedText;
import text.ModifyColorMapDialog;
import text.TextSource;

public class AttributedLabel
extends JComponent
implements MouseListener {
    protected AttributedString left;

    public Dimension getPreferredSize() {
        return new Dimension(this.left.getAttributedText().getWidth(), TextSource.fontMetrics.getHeight() + 2);
    }

    public void setText(AttributedString attributedString) {
        this.left = attributedString;
    }

    public void setText(String string) {
        this.left = AttributedString.CreateAttributedString(string);
        this.left.assignWidths();
    }

    public AttributedLabel() {
        this.setText("");
        this.addMouseListener(this);
    }

    public AttributedLabel(String string) {
        this.setText(string);
        this.addMouseListener(this);
    }

    public void paint(Graphics graphics) {
        TextSource.initGraphics(graphics);
        int n = super.getWidth();
        int n2 = super.getHeight();
        int n3 = n2 - 4;
        TextSource.drawText(graphics, this.left.getAttributedText(), 2, n3);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown()) {
            int n = 2;
            AttributedText attributedText = this.left.getAttributedText();
            while (attributedText != null && attributedText.width + n < mouseEvent.getX()) {
                n += attributedText.width;
                attributedText = attributedText.next;
            }
            if (attributedText != null) {
                int n2 = mouseEvent.isControlDown() && attributedText.backIndex > -1 ? attributedText.backIndex : attributedText.foreIndex;
                ModifyColorMapDialog.showModifyColorMapDialog(this, n2);
            }
            mouseEvent.consume();
            return;
        }
    }
}

