/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rero.gui.KeyBindings;
import text.WrappedDisplay;

public class FindDialog
extends JDialog
implements ActionListener,
KeyListener {
    protected JButton next;
    protected JButton prev;
    protected WrappedDisplay display;
    protected JTextField search;
    protected ListIterator results = null;
    protected Object lastSource = null;

    public void showDialog() {
        KeyBindings.is_dialog_active = true;
        this.results = null;
        this.next.setEnabled(false);
        this.prev.setEnabled(true);
        this.pack();
        this.setLocationRelativeTo(this.display);
        this.setVisible(true);
        this.search.selectAll();
        this.search.requestFocus();
    }

    public FindDialog(Component component, String string, WrappedDisplay wrappedDisplay, String string2) {
        super(JOptionPane.getFrameForComponent(component), string, false);
        this.display = wrappedDisplay;
        this.getContentPane().setLayout(new BorderLayout());
        this.search = new JTextField(string2, 20);
        this.search.addKeyListener(this);
        this.search.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new JLabel("Find: "));
        jPanel.add(this.search);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        this.next = new JButton("Next");
        this.next.setMnemonic('N');
        this.next.setEnabled(false);
        this.next.addActionListener(this);
        this.prev = new JButton("Previous");
        this.prev.setMnemonic('P');
        this.prev.setEnabled(string2.length() > 0);
        this.prev.addActionListener(this);
        jPanel2.add(this.prev);
        jPanel2.add(this.next);
        this.getContentPane().add((Component)jPanel2, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                KeyBindings.is_dialog_active = false;
                FindDialog.this.setVisible(false);
            }
        });
    }

    public static void main(String[] stringArray) {
        FindDialog findDialog = new FindDialog(null, "Testing", null, "hi");
        findDialog.showDialog();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            KeyBindings.is_dialog_active = false;
            this.setVisible(false);
            keyEvent.consume();
        } else if (!keyEvent.isActionKey() && keyEvent.getKeyCode() != 10) {
            this.results = null;
            this.next.setEnabled(this.search.getText().length() > 0);
            this.prev.setEnabled(this.search.getText().length() > 0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.results == null) {
            this.results = this.display.find(this.search.getText());
            this.lastSource = null;
        }
        if (actionEvent.getSource() == this.next && this.results.hasNext()) {
            if (this.lastSource == this.prev) {
                this.results.next();
            }
            int n = (Integer)this.results.next();
            this.display.scrollTo(n);
            this.lastSource = this.next;
        } else if ((actionEvent.getSource() == this.prev || actionEvent.getSource() == this.search) && this.results.hasPrevious()) {
            if (this.lastSource == this.next) {
                this.results.previous();
            }
            int n = (Integer)this.results.previous();
            this.display.scrollTo(n);
            this.lastSource = this.prev;
        }
        this.next.setEnabled(this.results.hasNext());
        this.prev.setEnabled(this.results.hasPrevious());
        this.search.requestFocus();
    }
}

