/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import text.AttributedString;
import text.AttributedText;
import text.ModifyColorMapDialog;
import text.TextSource;

public class LabelDisplay
extends JComponent
implements MouseListener {
    protected int lines;
    protected AttributedString[] left;
    protected AttributedString[] right;
    protected int[] right_widths;

    public void setNumberOfLines(int n) {
        this.lines = n;
        this.left = new AttributedString[n];
        this.right = new AttributedString[n];
        this.right_widths = new int[n];
        this.revalidate();
    }

    public int getTotalLines() {
        return this.lines;
    }

    public Dimension getPreferredSize() {
        int n = this.lines * TextSource.fontMetrics.getHeight() + 2;
        return new Dimension(Integer.MAX_VALUE, n);
    }

    public void setLine(String string, String string2, int n) {
        n = this.left.length - (n + 1);
        this.left[n] = AttributedString.CreateAttributedString(string);
        this.right[n] = AttributedString.CreateAttributedString(string2);
        this.left[n].assignWidths();
        this.right[n].assignWidths();
        this.right_widths[n] = this.right[n].getAttributedText().getWidth();
    }

    public LabelDisplay() {
        this.setNumberOfLines(1);
        this.addMouseListener(this);
    }

    public void paint(Graphics graphics) {
        int n;
        TextSource.initGraphics(graphics);
        int n2 = graphics.getClipBounds().y - 9;
        int n3 = n2 + graphics.getClipBounds().height + 20;
        int n4 = super.getWidth();
        int n5 = super.getHeight();
        int n6 = n5 - TextSource.fontMetrics.getDescent() - 1;
        for (n = 0; n < this.left.length && n6 > 0 && this.left[n] != null; n6 -= TextSource.fontMetrics.getHeight(), ++n) {
            if (n6 > n3 || n6 < n2) continue;
            TextSource.drawText(graphics, this.left[n].getAttributedText(), 0, n6);
        }
        n6 = n5 - TextSource.fontMetrics.getDescent() - 1;
        for (n = 0; n < this.right.length && n6 > 0 && this.right[n] != null; n6 -= TextSource.fontMetrics.getHeight(), ++n) {
            if (n6 > n3 || n6 < n2) continue;
            TextSource.drawText(graphics, this.right[n].getAttributedText(), n4 - this.right_widths[n], n6);
        }
    }

    public int translateToLineNumber(int n) {
        int n2 = this.getHeight() - TextSource.fontMetrics.getDescent() - 1;
        for (int i = 0; i < this.left.length && n2 > 0 && this.left[i] != null; n2 -= TextSource.fontMetrics.getHeight() + 0, ++i) {
            if (n < n2 - TextSource.fontMetrics.getHeight() - 0) continue;
            return i;
        }
        return 0;
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown()) {
            AttributedText attributedText;
            int n;
            int n2 = this.translateToLineNumber(mouseEvent.getY());
            if (mouseEvent.getX() >= this.getWidth() - this.right_widths[n2]) {
                n = this.getWidth() - this.right_widths[n2];
                attributedText = this.right[n2].getAttributedText();
            } else {
                n = 0;
                attributedText = this.left[n2].getAttributedText();
            }
            while (attributedText != null && attributedText.width + n < mouseEvent.getX()) {
                n += attributedText.width;
                attributedText = attributedText.next;
            }
            if (attributedText != null) {
                int n3 = mouseEvent.isControlDown() && attributedText.backIndex > -1 ? attributedText.backIndex : attributedText.foreIndex;
                ModifyColorMapDialog.showModifyColorMapDialog(this, n3);
            }
            return;
        }
    }
}

