/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.MouseInputListener;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import text.AttributedText;
import text.ModifyColorMapDialog;
import text.list.ListData;
import text.list.ListDisplayComponent;
import text.list.ListElement;
import text.list.ListSelectionSpace;

public class ListDisplay
extends JComponent
implements MouseWheelListener,
MouseInputListener,
ClientStateListener {
    protected ListDisplayComponent display;
    protected JScrollBar scroller = new JScrollBar(1, 0, 0, 0, 0);
    protected ListData data;
    protected ListSelectionSpace select;

    public ListElement getSelectedElement() {
        return this.select.getSelectedElement();
    }

    public LinkedList getSelectedElements() {
        return this.select.getSelectedElements();
    }

    public void propertyChanged(String string, String string2) {
        this.data.dirty();
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getWheelRotation() >= 0) {
            this.scroller.setValue(this.scroller.getValue() + mouseWheelEvent.getScrollAmount());
            this.repaint();
        } else {
            this.scroller.setValue(this.scroller.getValue() - mouseWheelEvent.getScrollAmount());
            this.repaint();
        }
    }

    public ListDisplay(ListData listData) {
        this.display = new ListDisplayComponent();
        this.select = new ListSelectionSpace(this, listData);
        this.addMouseListener(this.select);
        this.addMouseMotionListener(this.select);
        this.data = listData;
        this.display.installDataSource(listData);
        this.scroller.setModel(listData);
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        listData.addChangeListener(this.display);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroller, "East");
        this.add((Component)this.display, "Center");
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        ClientState.getClientState().addClientStateListener("ui.font", this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        AttributedText attributedText;
        ListElement listElement;
        if (mouseEvent.isShiftDown() && mouseEvent.isControlDown() && (listElement = this.data.getElementAtLocation(mouseEvent.getY())) != null && (attributedText = listElement.getAttributedText().getAttributesAt(mouseEvent.getX())) != null) {
            ModifyColorMapDialog.showModifyColorMapDialog(this, attributedText.foreIndex);
            this.repaint();
            mouseEvent.consume();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

