/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import rero.config.ClientDefaults;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.GlobalCapabilities;
import rero.gui.SessionManager;
import text.AttributedText;

public class TextSource {
    public static Font clientFont;
    public static FontMetrics fontMetrics;
    private static Object antiAliasHint;
    public static final int UNIVERSAL_TWEAK = 2;
    protected static TextSourceListener listener;
    public static Color[] colorTable;

    public static void saveColorMap() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(ClientState.getBaseDirectory(), "color.map"));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(colorTable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ClientState.getClientState().fireChange("color.map", null);
    }

    public static void initGraphics(Graphics graphics) {
        graphics.setFont(clientFont);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antiAliasHint);
    }

    public static int translateToLineNumber(int n) {
        return (n - 5) / (fontMetrics.getHeight() + 2);
    }

    public static void drawForeground(Graphics graphics, AttributedText attributedText, int n, int n2) {
        int n3 = fontMetrics.getHeight();
        while (attributedText != null) {
            graphics.setColor(colorTable[attributedText.foreIndex]);
            if (attributedText.isBold) {
                graphics.setColor(graphics.getColor().brighter());
            }
            if (attributedText.isReverse) {
                graphics.setColor(graphics.getColor().darker());
            }
            if (attributedText.isUnderline) {
                graphics.drawLine(n, n2 + 1, n + attributedText.width, n2 + 1);
            }
            graphics.drawString(attributedText.text, n, n2);
            n += attributedText.width;
            attributedText = attributedText.next;
        }
    }

    public static void drawBackground(Graphics graphics, AttributedText attributedText, int n, int n2) {
        int n3 = fontMetrics.getHeight();
        while (attributedText != null) {
            if (attributedText.backIndex != -1) {
                graphics.setColor(colorTable[attributedText.backIndex]);
                graphics.fillRect(n, n2 - n3 + 2, attributedText.width, n3 + 2);
            }
            n += attributedText.width;
            attributedText = attributedText.next;
        }
    }

    public static void drawText(Graphics graphics, AttributedText attributedText, int n, int n2) {
        TextSource.drawBackground(graphics, attributedText, n, n2);
        TextSource.drawForeground(graphics, attributedText, n, n2);
    }

    static {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(ClientState.getClientState().getResourceAsStream("color.map"));
            colorTable = (Color[])objectInputStream.readObject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (colorTable == null) {
            colorTable = new Color[100];
            TextSource.colorTable[0] = Color.lightGray;
            TextSource.colorTable[1] = new Color(0, 0, 0);
            TextSource.colorTable[2] = new Color(0, 0, 128);
            TextSource.colorTable[3] = new Color(0, 144, 0);
            TextSource.colorTable[4] = new Color(255, 0, 0);
            TextSource.colorTable[5] = new Color(128, 0, 0);
            TextSource.colorTable[6] = new Color(160, 0, 160);
            TextSource.colorTable[7] = new Color(255, 128, 0);
            TextSource.colorTable[8] = new Color(255, 255, 0);
            TextSource.colorTable[9] = new Color(0, 255, 0);
            TextSource.colorTable[10] = new Color(0, 144, 144);
            TextSource.colorTable[11] = new Color(0, 255, 255);
            TextSource.colorTable[12] = new Color(0, 0, 255);
            TextSource.colorTable[13] = new Color(255, 0, 255);
            TextSource.colorTable[14] = new Color(128, 128, 128);
            TextSource.colorTable[15] = Color.lightGray;
            TextSource.colorTable[16] = new Color(255, 255, 255);
            for (int i = 17; i < colorTable.length; ++i) {
                TextSource.colorTable[i] = colorTable[0];
            }
            TextSource.saveColorMap();
        }
        listener = new TextSourceListener();
    }

    private static class AdjustedFontMetrics
    extends FontMetrics {
        private int adj_ascent;
        private int adj_descent;
        private int height;
        private FontMetrics metrics;
        private FontRenderContext context;
        private Font font;

        public AdjustedFontMetrics(Font font, FontMetrics fontMetrics) {
            super(font);
            this.metrics = fontMetrics;
            this.adj_ascent = Math.abs(this.metrics.getMaxAscent());
            this.adj_descent = Math.abs(this.metrics.getMaxDescent());
            this.context = new FontRenderContext(null, antiAliasHint == RenderingHints.VALUE_TEXT_ANTIALIAS_ON, false);
            this.font = font;
            this.height = this.adj_ascent + this.adj_descent;
        }

        public int getAscent() {
            return this.adj_ascent;
        }

        public int getDescent() {
            return this.adj_descent;
        }

        public int getHeight() {
            return this.height;
        }

        public int stringWidth(String string) {
            return (int)Math.round(this.font.getStringBounds(string, this.context).getWidth());
        }
    }

    protected static class TextSourceListener
    implements ClientStateListener {
        public TextSourceListener() {
            ClientState.getClientState().addClientStateListener("ui.font", this);
            ClientState.getClientState().addClientStateListener("ui.antialias", this);
            this.rehashValue();
        }

        public void rehashValue() {
            if (ClientState.getClientState().isOption("ui.antialias", ClientDefaults.ui_antialias)) {
                antiAliasHint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            } else {
                antiAliasHint = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            }
            clientFont = ClientState.getClientState().getFont("ui.font", ClientDefaults.ui_font);
            fontMetrics = new AdjustedFontMetrics(clientFont, Toolkit.getDefaultToolkit().getFontMetrics(clientFont));
        }

        public void propertyChanged(String string, String string2) {
            this.rehashValue();
            SessionManager.getGlobalCapabilities();
            GlobalCapabilities.frame.validate();
            SessionManager.getGlobalCapabilities();
            GlobalCapabilities.frame.repaint();
        }
    }
}

