/*
 * Decompiled with CFR 0.152.
 */
package text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.MouseInputListener;
import rero.config.ClientState;
import rero.config.ClientStateListener;
import rero.gui.SessionManager;
import rero.gui.script.WindowAreaClickListener;
import text.AttributedText;
import text.FindDialog;
import text.ModifyColorMapDialog;
import text.event.ClickEvent;
import text.event.ClickListener;
import text.wrapped.SelectionSpace;
import text.wrapped.WrappedContainer;
import text.wrapped.WrappedData;
import text.wrapped.WrappedDisplayComponent;
import text.wrapped.WrappedNames;
import text.wrapped.WrappedObject;

public class WrappedDisplay
extends JComponent
implements MouseWheelListener,
MouseInputListener,
ClientStateListener {
    protected WrappedDisplayComponent display;
    protected JScrollBar scroller;
    protected WrappedData data;
    protected FindDialog search = null;
    protected LinkedList listeners = new LinkedList();

    public void showSearchDialog(String string) {
        if (this.search == null) {
            this.search = new FindDialog(this, string, this, "");
        }
        this.search.showDialog();
    }

    public void addText(String string) {
        this.data.addText(new WrappedContainer(string));
    }

    public void addTextTable(String string, String[] stringArray, double d) {
        this.data.addText(new WrappedNames(string, stringArray, d));
    }

    public void propertyChanged(String string, String string2) {
        this.data.dirty();
    }

    public void clear() {
        this.data.reset();
    }

    public ListIterator find(String string) {
        return this.data.find(string);
    }

    public void scroll(int n) {
        this.data.setValue(this.data.getValue() + n);
        this.repaint();
    }

    public void scrollTo(int n) {
        this.data.setValue(n);
        this.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getScrollAmount() - 1;
        if (n <= 0) {
            n = 1;
        }
        if (mouseWheelEvent.getWheelRotation() >= 0) {
            this.data.setValue(this.data.getValue() + n);
            this.repaint();
        } else {
            this.data.setValue(this.data.getValue() - n);
            this.repaint();
        }
    }

    public WrappedDisplay() {
        this.scroller = new JScrollBar(1, 0, 0, 0, 0);
        this.display = new WrappedDisplayComponent();
        this.data = new WrappedData();
        this.display.setWrappedData(this.data);
        this.scroller.setModel(this.data);
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.data.addChangeListener(this.display);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroller, "East");
        this.add((Component)this.display, "Center");
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        ClientState.getClientState().addClientStateListener("ui.font", this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.data.setValueIsAdjusting(false);
            return;
        }
        this.data.setValueIsAdjusting(true);
        this.data.setSelection(new SelectionSpace(mouseEvent.getPoint()));
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.data.setValueIsAdjusting(false);
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        if (this.data.getSelection() != null && this.data.getSelection().getSelectedText() != null && this.data.getSelection().getSelectedText().length() > 0) {
            StringSelection stringSelection = new StringSelection(this.data.getSelection().getSelectedText());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            if (Toolkit.getDefaultToolkit().getSystemSelection() != null) {
                Toolkit.getDefaultToolkit().getSystemSelection().setContents(stringSelection, stringSelection);
            }
        }
        this.data.setSelection(null);
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.data.setValueIsAdjusting(false);
            return;
        }
        if (mouseEvent.isShiftDown()) {
            WrappedObject wrappedObject = this.data.getAttributesAt(this.display.getHeight(), mouseEvent.getX(), mouseEvent.getY());
            if (wrappedObject != null && wrappedObject.getObject() != null) {
                AttributedText attributedText = (AttributedText)wrappedObject.getObject();
                int n = mouseEvent.isControlDown() && attributedText.backIndex > -1 ? attributedText.backIndex : attributedText.foreIndex;
                ModifyColorMapDialog.showModifyColorMapDialog(this, n);
            }
            return;
        }
        WrappedObject wrappedObject = this.data.getTokenAt(this.display.getHeight(), mouseEvent.getX(), mouseEvent.getY());
        if (wrappedObject != null && wrappedObject.getObject() != null) {
            if (this.fireClickEvent(wrappedObject.getObject().toString(), wrappedObject.getText(), mouseEvent).isAcknowledged()) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(300L);
                            WrappedDisplay.this.setCursor(Cursor.getDefaultCursor());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }).start();
            }
        } else {
            String string = SessionManager.getGlobalCapabilities().getActiveSession().getActiveWindow().getName();
            this.fireClickEvent(null, string, mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        if (this.data.getSelection() != null) {
            this.data.getSelection().growSelection(mouseEvent.getPoint());
            Rectangle rectangle = this.data.getSelection().getChangedArea();
            this.repaint(rectangle);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void addClickListener(ClickListener clickListener) {
        this.listeners.add(clickListener);
    }

    public ClickEvent fireClickEvent(String string, String string2, MouseEvent mouseEvent) {
        ClickEvent clickEvent = new ClickEvent(string, string2, mouseEvent);
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext() && !clickEvent.isConsumed()) {
            ClickListener clickListener = (ClickListener)listIterator.next();
            if (string == null && !(clickListener instanceof WindowAreaClickListener)) continue;
            clickListener.wordClicked(clickEvent);
        }
        return clickEvent;
    }
}

