/*
 * Decompiled with CFR 0.152.
 */
package text.list;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import text.TextSource;
import text.list.ListElement;

public abstract class ListData
implements BoundedRangeModel {
    protected ChangeEvent event = new ChangeEvent(this);
    protected LinkedList listeners = new LinkedList();
    protected int currentValue = 0;
    protected boolean adjusting = false;
    protected int extent = 1;

    public ListElement getElementAtLocation(int n) {
        int n2 = TextSource.fontMetrics.getHeight() + 2;
        int n3 = (n - n % n2) / n2 + this.currentValue;
        return this.getElementAt(n3);
    }

    public void dirty() {
    }

    public abstract int getSize();

    public abstract ListElement head();

    public abstract ListElement next();

    public abstract ListElement getElementAt(int var1);

    public abstract Iterator dataIterator();

    public Object getSynchronizationKeyOuter() {
        return null;
    }

    public Object getSynchronizationKeyInner() {
        return null;
    }

    public void fireChangeEvent() {
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext()) {
            ChangeListener changeListener = (ChangeListener)listIterator.next();
            changeListener.stateChanged(this.event);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public int getExtent() {
        return this.extent;
    }

    public int getMaximum() {
        return this.getSize();
    }

    public int getMinimum() {
        return 0;
    }

    public int getValue() {
        if (this.currentValue + this.extent > this.getSize()) {
            this.currentValue = this.getSize() - this.extent;
        }
        if (this.getSize() < this.extent) {
            this.currentValue = 0;
        }
        if (this.currentValue < this.getSize()) {
            return this.currentValue;
        }
        this.currentValue = this.getSize() - 1;
        return this.currentValue;
    }

    public boolean getValueIsAdjusting() {
        return this.adjusting;
    }

    public void setExtent(int n) {
        this.extent = n;
    }

    public void setMaximum(int n) {
    }

    public void setMinimum(int n) {
    }

    public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
    }

    public void setValue(int n) {
        this.currentValue = n < 0 ? 0 : (n < this.getSize() ? n : this.getSize() - 1);
        this.fireChangeEvent();
    }

    public void setValueIsAdjusting(boolean bl) {
        this.adjusting = bl;
    }
}

