/*
 * Decompiled with CFR 0.152.
 */
package text.wrapped;

import java.awt.Point;
import java.awt.Rectangle;
import text.TextSource;

public class SelectionSpace {
    protected boolean ready = false;
    protected int origin_x;
    protected int origin_y;
    protected int start_sel;
    protected int end_sel;
    protected int x;
    protected int y;
    boolean flipped;
    protected int lineStart = 0;
    protected int lineEnd = 0;
    protected StringBuffer selection;
    protected Rectangle changed;

    public SelectionSpace(Point point) {
        this.origin_x = (int)point.getX();
        this.origin_y = (int)point.getY();
        this.changed = new Rectangle(0, this.origin_y - (TextSource.fontMetrics.getHeight() + 2) * 1, 2048, (TextSource.fontMetrics.getHeight() + 2) * 2);
        this.ready = false;
    }

    public void clear() {
        this.selection = new StringBuffer();
    }

    public void append(String string) {
        if (string.length() > 0) {
            this.selection.insert(0, string);
        }
    }

    public void touch() {
        if (this.selection.length() > 0) {
            this.append("\n");
        }
    }

    public String getSelectedText() {
        if (this.selection != null) {
            return this.selection.toString();
        }
        return null;
    }

    protected int translateToLineNumber(int n) {
        int n2 = TextSource.fontMetrics.getHeight() + 2;
        return ((n -= 5) - n % n2) / n2;
    }

    protected int translateToPixel(int n) {
        return n * (TextSource.fontMetrics.getHeight() + 2) + 5;
    }

    public boolean isSelectedLine(int n) {
        int n2 = this.translateToLineNumber(n);
        return this.ready && n2 >= this.lineStart && n2 <= this.lineEnd;
    }

    public boolean isOnlyLine(int n) {
        return this.isStartLine(n) && this.isEndLine(n);
    }

    public boolean isEndLine(int n) {
        int n2 = this.translateToLineNumber(n);
        return this.ready && n2 == this.lineEnd;
    }

    public boolean isStartLine(int n) {
        int n2 = this.translateToLineNumber(n);
        return this.ready && n2 == this.lineStart;
    }

    public int getSingleStart() {
        if (this.start_sel < this.end_sel) {
            return this.start_sel;
        }
        return this.end_sel;
    }

    public int getSingleEnd() {
        if (this.start_sel < this.end_sel) {
            return this.end_sel;
        }
        return this.start_sel;
    }

    public int getSelectionStart() {
        return this.start_sel;
    }

    public int getSelectionEnd() {
        return this.end_sel;
    }

    public Rectangle getChangedArea() {
        return this.changed;
    }

    public void growSelection(Point point) {
        int n;
        this.ready = true;
        this.x = (int)point.getX();
        this.y = (int)point.getY();
        this.flipped = this.y < this.origin_y;
        if (this.flipped) {
            this.lineStart = this.translateToLineNumber(this.y);
            this.lineEnd = this.translateToLineNumber(this.origin_y);
        } else {
            this.lineStart = this.translateToLineNumber(this.origin_y);
            this.lineEnd = this.translateToLineNumber(this.y);
        }
        if (this.flipped) {
            this.start_sel = this.x;
            this.end_sel = this.origin_x;
        } else {
            this.start_sel = this.origin_x;
            this.end_sel = this.x;
        }
        int n2 = this.translateToPixel(this.lineStart - 1);
        if ((double)n2 > this.changed.getY()) {
            n2 = (int)this.changed.getY();
        }
        if ((double)(n = this.translateToPixel(this.lineEnd + 2) - n2) < this.changed.getHeight()) {
            n = (int)this.changed.getHeight();
        }
        this.changed.setBounds(0, n2, 2048, n);
    }
}

