/*
 * Decompiled with CFR 0.152.
 */
package text.wrapped;

import java.util.LinkedList;
import java.util.ListIterator;
import rero.util.TokenizedString;
import text.AttributedString;
import text.AttributedText;
import text.TextSource;

public class WrappedContainer {
    protected int maxSize;
    protected int minSize;
    protected WrappedContainer next = null;
    protected WrappedContainer prev = null;
    protected AttributedString text;
    protected AttributedText[] wrapped;

    public WrappedContainer(String string) {
        this.text = AttributedString.CreateAttributedString(string);
    }

    public WrappedContainer next() {
        return this.next;
    }

    public WrappedContainer previous() {
        return this.prev;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public boolean hasPrevious() {
        return this.prev != null;
    }

    public void setNext(WrappedContainer wrappedContainer) {
        this.next = wrappedContainer;
    }

    public void setPrevious(WrappedContainer wrappedContainer) {
        this.prev = wrappedContainer;
    }

    public void touch(int n) {
        if (n >= this.minSize && n <= this.maxSize) {
            return;
        }
        this.wrapped = WrappedContainer.wrap(this.text, n);
        this.determineBounds(n);
    }

    public void reset() {
        this.minSize = 786432;
        this.maxSize = 0;
    }

    protected void determineBounds(int n) {
        this.minSize = 0;
        this.maxSize = Integer.MAX_VALUE;
        for (int i = 0; i < this.wrapped.length; ++i) {
            int n2 = 0;
            AttributedText attributedText = this.wrapped[i];
            while (attributedText != null) {
                n2 += attributedText.width;
                attributedText = attributedText.next;
            }
            if (n2 <= this.minSize) continue;
            this.minSize = n2;
        }
        this.maxSize = n + 50;
    }

    public AttributedText[] getWrappedText() {
        return this.wrapped;
    }

    public String getText() {
        return this.text.getText();
    }

    public String getTokenAt(AttributedText attributedText, int n) {
        if (attributedText.isIndent()) {
            n -= attributedText.width;
            attributedText = attributedText.next;
        }
        String string = attributedText.getText();
        TokenizedString tokenizedString = new TokenizedString(string, " ");
        for (int i = 0; i < tokenizedString.getTotalTokens() + 1; ++i) {
            int n2;
            if (TextSource.fontMetrics.stringWidth(tokenizedString.getTokenTo(i)) <= n) continue;
            String string2 = i > 0 ? tokenizedString.getToken(i - 1) : tokenizedString.getToken(0);
            if (this.text.getTokens().isToken(string2)) {
                return string2;
            }
            for (n2 = 0; n2 < this.text.getTokens().getTotalTokens(); ++n2) {
                if (string2.length() >= this.text.getTokens().getToken(n2).length() || !this.text.getTokens().getToken(n2).substring(0, string2.length()).equals(string2)) continue;
                return this.text.getTokens().getToken(n2);
            }
            for (n2 = 0; n2 < this.text.getTokens().getTotalTokens(); ++n2) {
                if (string2.length() >= this.text.getTokens().getToken(n2).length() || this.text.getTokens().getToken(n2).indexOf(string2) <= -1) continue;
                return this.text.getTokens().getToken(n2);
            }
            return string2;
        }
        return null;
    }

    public AttributedText getAttributedTextAt(AttributedText attributedText, int n) {
        int n2 = 0;
        while (attributedText != null && n2 + attributedText.width < n) {
            n2 += attributedText.width;
            attributedText = attributedText.next;
        }
        return attributedText;
    }

    public static AttributedText[] wrap(AttributedString attributedString, int n) {
        AttributedText attributedText;
        int n2;
        if (n < 100) {
            return new AttributedText[0];
        }
        TokenizedString tokenizedString = attributedString.getTokens();
        LinkedList<AttributedText> linkedList = new LinkedList<AttributedText>();
        String string = attributedString.getText();
        String string2 = "";
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string3 = "";
        int n7 = 0;
        while (n3 <= tokenizedString.getTotalTokens()) {
            if (n7 >= n) {
                int n8 = TextSource.fontMetrics.stringWidth(tokenizedString.getToken(n3 - 1)) + n6;
                if (n4 == n5 && n8 < n) {
                    n5 = string2.length();
                    string2 = tokenizedString.getTokenTo(++n3);
                    n7 = TextSource.fontMetrics.stringWidth(string.substring(n4, string2.length())) + n6;
                    continue;
                }
                if (n8 >= n) {
                    for (n2 = n4 + 1; n2 < string2.length() && TextSource.fontMetrics.stringWidth(string.substring(n4, n2)) + n6 < n; ++n2) {
                    }
                    --n2;
                    if (string3.length() > 0) {
                        attributedText = new AttributedText();
                        attributedText.text = string3;
                        attributedText.width = n6;
                        attributedText.next = attributedString.substring(n4, n2);
                        attributedText.setIndent();
                    } else {
                        attributedText = attributedString.substring(n4, n2);
                    }
                    linkedList.add(attributedText);
                    string3 = "   ";
                    n6 = TextSource.fontMetrics.stringWidth("   ");
                    for (n4 = n2; n4 < string.length() && string.charAt(n4) == ' '; ++n4) {
                    }
                    n5 = n4;
                    n7 = TextSource.fontMetrics.stringWidth(string.substring(n4, string2.length())) + n6;
                    continue;
                }
                if (string3.length() > 0) {
                    attributedText = new AttributedText();
                    attributedText.text = string3;
                    attributedText.width = n6;
                    attributedText.next = attributedString.substring(n4, n5);
                    attributedText.setIndent();
                } else {
                    attributedText = attributedString.substring(n4, n5);
                }
                linkedList.add(attributedText);
                string3 = "   ";
                n6 = TextSource.fontMetrics.stringWidth("   ");
                for (n4 = n5; n4 < string.length() && string.charAt(n4) == ' '; ++n4) {
                }
                n5 = n4;
                continue;
            }
            n5 = string2.length();
            string2 = tokenizedString.getTokenTo(++n3);
            n7 = TextSource.fontMetrics.stringWidth(string.substring(n4, string2.length())) + n6;
        }
        if (n4 < string.length()) {
            if (string3.length() > 0) {
                attributedText = new AttributedText();
                attributedText.text = string3;
                attributedText.width = n6;
                attributedText.next = attributedString.substring(n4, n5);
                attributedText.setIndent();
            } else {
                attributedText = attributedString.substring(n4, n5);
            }
            linkedList.add(attributedText);
        }
        AttributedText[] attributedTextArray = new AttributedText[linkedList.size()];
        n2 = linkedList.size() - 1;
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            attributedTextArray[n2] = (AttributedText)listIterator.next();
            --n2;
        }
        return attributedTextArray;
    }
}

