/*
 * Decompiled with CFR 0.152.
 */
package text.wrapped;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rero.config.ClientState;
import text.AttributedText;
import text.TextSource;
import text.wrapped.SelectionSpace;
import text.wrapped.WrappedContainer;
import text.wrapped.WrappedObject;

public class WrappedData
implements BoundedRangeModel {
    private static int WRAP_TOLERANCE = 2000;
    private static int WRAP_TO = 1000;
    protected WrappedContainer last = null;
    protected WrappedContainer text = null;
    protected WrappedContainer head = null;
    protected int tempMax = 1;
    protected int maxValue = 1;
    protected int currentValue = 0;
    protected boolean adjusting = false;
    protected LinkedList listeners = new LinkedList();
    protected ChangeEvent event;
    protected int extent = 1;
    protected int tempExtent = 1;
    protected Runnable changeEventTask = new Runnable(){

        public void run() {
            WrappedData.this.fireChangeEvent();
        }
    };
    protected SelectionSpace selection;

    public WrappedData() {
        this.event = new ChangeEvent(this);
    }

    public ListIterator find(String string) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n = 0;
        WrappedContainer wrappedContainer = this.last;
        while (wrappedContainer != null) {
            if (wrappedContainer.getText().toUpperCase().indexOf(string.toUpperCase()) > -1) {
                linkedList.add(new Integer(n));
            }
            ++n;
            wrappedContainer = wrappedContainer.prev;
        }
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            int n2 = (Integer)listIterator.next();
            if (n2 < this.currentValue) continue;
            listIterator.previous();
            break;
        }
        return listIterator;
    }

    public void dirty() {
        for (WrappedContainer wrappedContainer = this.last; wrappedContainer != null; wrappedContainer = wrappedContainer.previous()) {
            wrappedContainer.reset();
        }
    }

    public void reset() {
        this.tempMax = 1;
        this.maxValue = 1;
        this.currentValue = 0;
        this.extent = 1;
        this.tempExtent = 1;
        this.head = null;
        this.last = null;
        this.text = null;
        this.fireChangeEvent();
    }

    public WrappedContainer getCurrentText() {
        return this.text;
    }

    public WrappedObject getTokenAt(int n, int n2, int n3) {
        int n4 = n - 5;
        int n5 = 0;
        int n6 = TextSource.translateToLineNumber(n3);
        for (WrappedContainer wrappedContainer = this.text; wrappedContainer != null && n4 > 0; wrappedContainer = wrappedContainer.next()) {
            AttributedText[] attributedTextArray = wrappedContainer.getWrappedText();
            for (int i = 0; attributedTextArray != null && i < attributedTextArray.length && n4 > 0; n4 -= TextSource.fontMetrics.getHeight() + 2, ++i) {
                if (n3 >= n4 - TextSource.fontMetrics.getHeight() - 2) {
                    return new WrappedObject(wrappedContainer.getText(), wrappedContainer.getTokenAt(attributedTextArray[i], n2));
                }
                ++n5;
            }
        }
        return null;
    }

    public WrappedObject getAttributesAt(int n, int n2, int n3) {
        int n4 = n - 5;
        int n5 = 0;
        int n6 = TextSource.translateToLineNumber(n3);
        for (WrappedContainer wrappedContainer = this.text; wrappedContainer != null && n4 > 0; wrappedContainer = wrappedContainer.next()) {
            AttributedText[] attributedTextArray = wrappedContainer.getWrappedText();
            for (int i = 0; i < attributedTextArray.length && n4 > 0; n4 -= TextSource.fontMetrics.getHeight() + 2, ++i) {
                if (n3 >= n4 - TextSource.fontMetrics.getHeight() - 2) {
                    return new WrappedObject(wrappedContainer.getText(), wrappedContainer.getAttributedTextAt(attributedTextArray[i], n2));
                }
                ++n5;
            }
        }
        return null;
    }

    public void fireChangeEvent() {
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext()) {
            ChangeListener changeListener = (ChangeListener)listIterator.next();
            changeListener.stateChanged(this.event);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void addText(WrappedContainer wrappedContainer) {
        boolean bl = true;
        if (this.head == null) {
            this.head = wrappedContainer;
            this.text = wrappedContainer;
            this.last = wrappedContainer;
        } else {
            wrappedContainer.setNext(this.head);
            this.head.setPrevious(wrappedContainer);
            this.head = wrappedContainer;
            if (this.text.previous() != this.head) {
                ++this.maxValue;
            } else if (!this.getValueIsAdjusting()) {
                this.text = wrappedContainer;
                if (this.maxValue > WRAP_TOLERANCE) {
                    while (this.maxValue > WRAP_TO && this.last.hasPrevious()) {
                        this.last = this.last.previous();
                        --this.maxValue;
                    }
                    this.last.setNext(null);
                }
                this.currentValue = this.maxValue++;
            } else {
                ++this.tempMax;
            }
        }
        SwingUtilities.invokeLater(this.changeEventTask);
    }

    public int getExtent() {
        return 1;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public int getMinimum() {
        return 0;
    }

    public int getValue() {
        return this.currentValue;
    }

    public boolean getValueIsAdjusting() {
        return this.adjusting;
    }

    public void setExtent(int n) {
        this.extent = n;
    }

    public void setMaximum(int n) {
    }

    public void setMinimum(int n) {
    }

    public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
    }

    public void setValue(int n) {
        if (this.head == null) {
            return;
        }
        if (this.currentValue > n) {
            while (this.currentValue > n && this.text.hasNext()) {
                this.text = this.text.next();
                --this.currentValue;
            }
        } else if (this.currentValue < n) {
            while (this.currentValue < n && this.text.hasPrevious()) {
                this.text = this.text.previous();
                ++this.currentValue;
            }
        }
        this.currentValue = n;
        if (this.currentValue >= this.maxValue) {
            this.currentValue = this.maxValue - 1;
        }
        if (this.currentValue < 0) {
            this.currentValue = 0;
        }
        this.fireChangeEvent();
    }

    public void setValueIsAdjusting(boolean bl) {
        this.adjusting = bl;
        if (!bl && this.tempMax > this.maxValue) {
            this.maxValue = this.tempMax;
        } else {
            this.tempMax = this.maxValue;
        }
    }

    public void setSelection(SelectionSpace selectionSpace) {
        this.selection = selectionSpace;
    }

    public SelectionSpace getSelection() {
        return this.selection;
    }

    static {
        WRAP_TOLERANCE = ClientState.getClientState().getInteger("ui.buffersize", 2000);
        WRAP_TO = WRAP_TOLERANCE / 2;
    }
}

