/*
 * Decompiled with CFR 0.152.
 */
package text.wrapped;

import java.util.LinkedList;
import java.util.ListIterator;
import text.AttributedString;
import text.AttributedText;
import text.wrapped.WrappedContainer;

public class WrappedNames
extends WrappedContainer {
    protected AttributedText[] rawData;
    protected double percentage;
    protected String[] users;

    public WrappedNames(String string, String[] stringArray, double d) {
        super(string);
        this.users = stringArray;
        this.calculateAttributes();
        this.percentage = d;
    }

    public void calculateAttributes() {
        this.rawData = new AttributedText[this.users.length];
        for (int i = 0; i < this.users.length; ++i) {
            AttributedString attributedString = AttributedString.CreateAttributedString(this.users[i]);
            attributedString.assignWidths();
            this.rawData[i] = attributedString.getAttributedText();
        }
    }

    public void touch(int n) {
        int n2 = (int)((double)n * this.percentage);
        if (n2 < this.maxSize && n2 > this.minSize) {
            return;
        }
        this.wrapped = this.wrapNames(n2);
        this.determineBounds(n2);
    }

    public void reset() {
        super.reset();
        this.calculateAttributes();
    }

    public AttributedText[] wrapNames(int n) {
        AttributedText attributedText;
        LinkedList<AttributedText> linkedList = new LinkedList<AttributedText>();
        AttributedText attributedText2 = attributedText = this.rawData[0].cloneList();
        while (attributedText2.next != null) {
            attributedText2 = attributedText2.next;
        }
        int n2 = this.rawData[0].getWidth();
        for (int i = 1; i < this.rawData.length; ++i) {
            if ((n2 += this.rawData[i].getWidth()) > n) {
                linkedList.add(attributedText);
                attributedText = this.rawData[i].cloneList();
                n2 = attributedText.getWidth();
                attributedText2 = attributedText;
                while (attributedText2.next != null) {
                    attributedText2 = attributedText2.next;
                }
                continue;
            }
            attributedText2.next = this.rawData[i].cloneList();
            while (attributedText2.next != null) {
                attributedText2 = attributedText2.next;
            }
        }
        linkedList.add(attributedText);
        AttributedText[] attributedTextArray = new AttributedText[linkedList.size()];
        int n3 = linkedList.size() - 1;
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            attributedTextArray[n3] = (AttributedText)listIterator.next();
            --n3;
        }
        return attributedTextArray;
    }
}

