# Copyright 2015, Corix Aps

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#

require 'sketchup.rb'
require 'extensions.rb'
# require 'langhandler.rb'

# Put translation object where the extension can find it.
# $fs_strings = LanguageHandler.new("jjn_drawtools.strings")

# Load the extension.
# extension_name = $fs_strings.GetString("Draw Ring")

#if not Sketchup.is_pro?
#  extension_name += " " + $fs_strings.GetString("(Pro Only)")
#end

fs_extension = SketchupExtension.new(
    "Draw Ring", "jjn_drawtools/jjn_draw_ring.rbs")

fs_extension.description = "Create a closed ring/strip with one or more loops. " +
    "The cross section is either a rectangle or an ellipse (e.g. a circle). " +
	"Optionally add a number of twists, which are either internal (rotating around the center of the cross section) "+
	"or external (rotating around a point offset from the center of the cross section)."
	
fs_extension.version = "1.3"
fs_extension.creator = "Jens Jørgen Nielsen"
fs_extension.copyright = "2015, www.corix.dk"

# Register the extension with Sketchup.
Sketchup.register_extension fs_extension, true
