import bpy
from bpy.props import *
from bpy.types import PropertyGroup


class SKMPScnProperties(PropertyGroup):
    mirror_method: EnumProperty(items=[
        ("TOPOLOGY_MIRROR", "TOPOLOGY MIRROR", "Use topology to match mirrored vertices"), ("PERFECT_MIRROR", "PERFECT MIRROR",
                                                                                            "Every vert must have a unique mirrored vertex"), ("FORCE_MIRROR", "FORCED MIRROR",  "Forces mirror with nearest matching mirrored vertex")
    ])

    text_filter: StringProperty(
        default='', description="Used in operators that are labeled (Filtered) only effect ones containing this filter")
    text_rename: StringProperty(
        default='', description="Used in operators that are labeled (Filtered) only rename filtered text to this string")
    vgroup: StringProperty(
        default='', description="Vertex Group to assign to new shape keys")

    selected_only: BoolProperty(
        default=False, description="Limit to only selected geometry")
    copy_world_space: BoolProperty(
        default=False, description="Use world space coordinates")
    limit_selected: BoolProperty(default=False, description="")
    copy_drivers: BoolProperty(
        default=False, description="Turn this on to copy drivers when duplicating shapekeys")
    absoulte_mirror_coordinates: BoolProperty(
        default=False, description="Absolute shape key mirroring")
    assign_vgroup: BoolProperty(
        default=False, description="Assign a new vertex group to duplicated shape keys")
    rename_driver_bones: BoolProperty(
        default=False, description="Rename the bones according the shape key filter")
    explode_apply_vgroup: BoolProperty(
        default=False, description="Apply Vertex Group Weights")

    copy_and_separate_bool: BoolProperty(default=False, description="")
    parent_menu_bool: BoolProperty(default=False, description="")

    copy_scale: FloatProperty(default=1.00, min=0.00,
                              max=100.00, description="Scale of deformation")
    sep_distance: FloatProperty(default=5.00, min=0.00, max=100.00,
                                description="Exploded shape keys separation distance")

    mirror_axis: IntProperty(default=0, min=0, max=2,
                             description="Axis to mirror shape keys")
    smooth_iterations: IntProperty(
        default=2, min=0, max=50, description="Iterations of corrective smoothing to apply to result")


class shape_key_props(PropertyGroup):
    """The data structure for the muscle targets"""
    parent_sk: StringProperty(
        description='Parent Shape Key that will copy to child when relationship refreshed')
    child_sk: StringProperty(
        description='Child Shape Key to will inherit from parent when relationship refreshed')


class shape_key_collection(PropertyGroup):
    shape_key_coll: CollectionProperty(type=shape_key_props)
    index: IntProperty()


def register():
    bpy.utils.register_class(shape_key_props)
    bpy.utils.register_class(shape_key_collection)
    bpy.utils.register_class(SKMPScnProperties)

    bpy.types.Scene.skmp_props = PointerProperty(type=SKMPScnProperties)
    bpy.types.Object.skmp_par_coll = PointerProperty(type=shape_key_collection)
    return


def unregister():
    bpy.utils.unregister_class(shape_key_props)
    bpy.utils.unregister_class(shape_key_collection)
    bpy.utils.unregister_class(SKMPScnProperties)

    del bpy.types.Scene.skmp_props
    del bpy.types.Object.skmp_par_coll
    return
