"""Functions for exporting objects."""

import bpy

from rizomuv_bridge_link.data import constants


def export_selected(file_type: str) -> None:
    """Export selected objects to a file.

    Args:
        file_type: The file type to export.
    """
    match file_type:
        case "FBX":
            bpy.ops.export_scene.fbx(
                filepath=str(constants.FBX_PATH),
                use_selection=True,
                global_scale=1.0,
                object_types={"MESH"},
                use_mesh_edges=True,
                use_tspace=True,
                bake_anim=False,
                use_mesh_modifiers=False,
                use_subsurf=False,
                axis_forward="-Z",
                axis_up="Y",
                use_custom_props=False,
            )
        case "OBJ":
            if bpy.app.version >= (3, 3, 0):
                bpy.ops.wm.obj_export(
                    filepath=str(constants.OBJ_PATH),
                    export_selected_objects=True,
                    apply_modifiers=False,
                    export_materials=False,
                    export_smooth_groups=True,
                )
            else:
                bpy.ops.export_scene.obj(
                    filepath=str(constants.OBJ_PATH),
                    use_selection=True,
                    use_mesh_modifiers=False,
                    use_smooth_groups=True,
                    use_normals=True,
                    use_materials=False,
                )
