"""Object import functions."""

import bpy

from rizomuv_bridge_link.data import constants


def import_file(file_type: str) -> None:
    """Pick a transfer file and import the contents to the Blender scene.

    Args:
        file_type: The type of file to import ("OBJ", "FBX")
    """

    match file_type:
        case "FBX":
            bpy.ops.import_scene.fbx(filepath=str(constants.FBX_PATH))
        case "OBJ":
            if bpy.app.version >= (3, 3, 0):
                bpy.ops.wm.obj_import(filepath=str(constants.OBJ_PATH))
            else:
                bpy.ops.import_scene.obj(filepath=str(constants.OBJ_PATH))
