"""Functions that edit mesh data."""

import bmesh
from bpy.types import Object


def triangulate_objects(objects: list[Object]) -> None:
    """Triangulate given objects.

    Args:
        objects: Objects to triangulate.
    """
    for obj in objects:
        bm = bmesh.new()
        bm.from_mesh(obj.data)
        bmesh.ops.triangulate(bm, faces=bm.faces)
        bm.select_flush(True)
        bm.to_mesh(obj.data)


def change_name(obj: Object) -> None:
    """
    Change object name, replacing "." character.
    This is necessary as RizomUV replaces it with ":" making it hard to match objects.

    Args:
        obj: object to rename.
    """
    obj.name.replace(".", "_")
