"""General helper functions for Blender specific code."""

import bpy


def sel_mode(vert: bool = False, edge: bool = False, face: bool = False):
    """
    Get and set a selection mode. If no arg is set to True, then it will not change
    a selection mode.
    Args:
        vert (bool, optional): Set vertex mode. Defaults to False.
        edge (bool, optional): Set edge mode. Defaults to False.
        face (bool, optional): Set face mode. Defaults to False.
    Returns:
        tuple[bool, bool, bool]: Booleans representing original settings.
    """

    mode = bpy.context.scene.tool_settings.mesh_select_mode

    if vert or edge or face:
        bpy.context.scene.tool_settings.mesh_select_mode = (vert, edge, face)

    return mode
