"""This is a tool to parse JSON files."""

import json
from pathlib import Path


class JsonUtility:
    """Utility tool for reading JSON files."""

    def __init__(self, json_path: Path):
        """

        Args:
            json_path: Path to the json file.

        Returns:

        """
        self.json_path = json_path

    def read_string(self, dictionary: str, key: str) -> str:
        """

        Args:
            dictionary: The name of the dictionary in the json file.
            key: The key of the dictionary value to be read.

        Returns:

        """
        json_path = self.json_path
        with open(json_path) as json_file:
            json_object = json.load(json_file)
            json_file.close()

        return str(json_object[dictionary][key])
