"""General utility functions."""

import itertools
import string


def find_unique_name(names: list[str]) -> str:
    """
    Generate a unique name for the dummy UV map to avoid clashes.

    Args:
        names: List of names to check unique name against.

    Returns:
        Generated name.
    """

    letters = list(string.ascii_letters)

    def n_length_permutations(n: int) -> str:
        """Test every possible combination.

        Args:
            n: Length of the string combinations to generate.

        Returns:
            Generated name.
        """

        for permutation in itertools.permutations(letters, n):
            name = "".join([char for char in permutation])
            if name not in names:
                return name
        n += 1
        return n_length_permutations(n)

    return n_length_permutations(1)

