"""Utility functions to help locate the RizomUV install directory."""

import os
import winreg


def win_get_latest_ruv() -> str | None:
    """Finds the latest version of Rizom installed on Windows.

    Returns:
        Either the installation path of Rizom or none if it could not be found.
    """
    for major in range(9, 1, -1):
        for minor in range(10, -1, -1):
            if major == 2 and minor < 2:
                continue
            rizom_reg_path = f"SOFTWARE\\Rizom Lab\\RizomUV VS RS 202{major}.{minor}"
            try:
                key = winreg.OpenKey(winreg.HKEY_LOCAL_MACHINE, rizom_reg_path)
                exe_path = winreg.QueryValue(key, "rizomuv.exe")
                return os.path.dirname(exe_path)
            except FileNotFoundError:
                pass

    return None
