"""Convert between different unit types."""


def texel_density(tex_den: float, unit: str) -> float:
    """Convert texel density value to different units of measurement.

    Args:
        tex_den: The texel density value.
        unit: The unit to convert to. Must be a dictionary key.

    Returns:
        The converted texel density value.
    """

    unit_dict = {
        "km": tex_den,
        "m": tex_den,
        "dm": tex_den * 10,
        "cm": tex_den * 100,
        "mm": tex_den * 1000,
        "in": tex_den * 39.370079,
        "ft": tex_den * 3.28084,
        "yd": tex_den * 1.093613,
        "mi": tex_den * 0.000621371,
    }

    return unit_dict[unit]
