"""Sub panel that docks in under the operations tab."""

import bpy
from bpy.types import Context, UILayout

from rizomuv_bridge_link.data import constants
from rizomuv_bridge_link.preferences import RizomUVBridgePreferences


class RizomUVActionsAdvancedSettingsPanel(bpy.types.Panel):
    """Advanced addon settings panel."""

    bl_idname = "PANEL_PT_RizomUVBridgeAdvancedSettings"
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"
    bl_category = "RizomUV"
    bl_context = "objectmode"
    bl_label = "Advanced Settings"
    bl_parent_id = "PANEL_PT_RizomUVBridge"
    bl_options = {"DEFAULT_CLOSED"}

    def __init__(self):
        self.prefs: RizomUVBridgePreferences = bpy.context.preferences.addons[constants.PACKAGE_NAME].preferences

    @classmethod
    def poll(cls, context: Context) -> bool:
        """Tests if the operator is able to run.

        Args:
            context: Current data context.

        Returns:
            Check the ADDON_SETTINGS UI tab is selected.
        """
        return context.window_manager.RizomUVBridgeGUITabs.tabs == "ADDON_SETTINGS"

    def draw(self, context: Context) -> None:
        """Draw UI elements into the panel UI layout.

        Args:
            context: Current data context.
        """
        layout = self.layout

        box = layout.box()
        self.advanced_settings(box)

    def advanced_settings(self, container: UILayout):
        """The UI group for the advanced addon settings.

        Args:
            container: Box UI element to insert a UI group into.
        """
        row = container.row(align=True)
        row.scale_y = 1.3
        row.prop(self.prefs, "category_name")
