"""Sub panel that docks in under the operations tab."""

import bpy
from bpy.types import Context, UILayout

from rizomuv_bridge_link.data import constants
from rizomuv_bridge_link.preferences import RizomUVBridgePreferences


class RizomUVImportSettingsPanel(bpy.types.Panel):
    """Import settings panel."""

    bl_idname = "PANEL_PT_RizomUVBridgeImportSettings"
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"
    bl_category = "RizomUV"
    bl_context = "objectmode"
    bl_label = "Import Settings"
    bl_parent_id = "PANEL_PT_RizomUVBridge"

    def __init__(self):
        self.prefs: RizomUVBridgePreferences = bpy.context.preferences.addons[constants.PACKAGE_NAME].preferences

    @classmethod
    def poll(cls, context):
        """Check given condition to see if class should be available.

        Args:
            context (Context): Current windowmanager and data context.

        Returns:
            Bool: Check the OPERATIONS UI tab is selected.
        """
        return context.window_manager.RizomUVBridgeGUITabs.tabs == "OPERATIONS"

    def draw(self, context: Context) -> None:
        """Draw UI elements into the panel UI layout.

        Args:
            context: Current data context.

        """
        layout = self.layout

        box = layout.box()
        self.import_options(box)

    def import_options(self, container: UILayout) -> None:
        """The UI group for the import settings.

        Args:
            container: Box UI element to insert a UI group into.
        """
        row = container.row(align=True)
        row.scale_y = 1.3
        row.prop(self.prefs, "delete_uvmaps")
        if self.prefs.file_type != "FBX":
            row.enabled = False

        row = container.row(align=True)
        row.scale_y = 1.3
        row.prop(self.prefs, "reveal_hidden")
        row.prop(self.prefs, "replace_objects")

        row = container.row(align=True)
        row.scale_y = 1.3
        row.prop(self.prefs, "mark_sharp")
        row.prop(self.prefs, "mark_seams")
