"""Reset the RizomUV settings in the addon panel."""

from typing import TYPE_CHECKING

import bpy
from bpy.types import Context

from rizomuv_bridge_link.data import constants

if TYPE_CHECKING:
    from rizomuv_bridge_link.preferences import RizomUVBridgePreferences


class ResetAddonPreferencesRizom(bpy.types.Operator):
    """Reset the RizomUV settings in the addon panel."""

    bl_description = "Reset RizomUV Panel"
    bl_idname = "ruv_link.reset_prefs"
    bl_label = "Reset Preferences"
    bl_options = {"REGISTER", "INTERNAL"}

    def __init__(self):
        self.prefs: RizomUVBridgePreferences = bpy.context.preferences.addons[constants.PACKAGE_NAME].preferences

    def execute(self, context: Context) -> set[str]:
        """Execute the operator.

        Args:
            context: Current data context.

        Returns:
            Enum in {'RUNNING_MODAL', 'CANCELLED', 'FINISHED', 'PASS_THROUGH'}
        """

        rizom_prefs = (
            "margin",
            "padding",
            "td_target",
            "td_unit",
            "prevent_flips",
            "prevent_overlaps",
            "accuracy",
            "iterations",
            "orientation",
            "step_angle",
        )

        self.prefs.map_res = 2048 # Have to do this manually, not sure why.

        for pref in rizom_prefs:
            self.prefs.property_unset(pref)

        return {"FINISHED"}
