"""Load existing file in Rizom using RizomUVLiveLink module."""

from typing import TYPE_CHECKING

import bpy
from bpy.types import Context

from rizomuv_bridge_link.data import constants
from rizomuv_bridge_link.functions.rizomuv_link import rizomuv_link_manager

if TYPE_CHECKING:
    from rizomuv_bridge_link.preferences import RizomUVBridgePreferences


class RizomLoad(bpy.types.Operator):
    """Load existing file in Rizom (No export)."""

    bl_description = "Load the currently selected file in Rizom. No Export"
    bl_idname = "ruv_link.rizom_load"
    bl_label = "Load (RizomUV)"
    bl_options = {"REGISTER", "INTERNAL"}

    def __init__(self):
        self.prefs: "RizomUVBridgePreferences" = bpy.context.preferences.addons[constants.PACKAGE_NAME].preferences

    def execute(self, context: Context) -> set[str]:
        """Execute the operator.

        Args:
            context: Current data context.

        Returns:
            Enum in {'RUNNING_MODAL', 'CANCELLED', 'FINISHED', 'PASS_THROUGH'}
        """

        link_manager = rizomuv_link_manager.RizomUVLinkManager(self.prefs.rizom_path)
        link_manager.run_rizom()

        params = {
            "File.Path": {"FBX": str(constants.FBX_PATH), "OBJ": str(constants.OBJ_PATH)}[self.prefs.file_type],
            "File.XYZUVW": True,
            "File.UVWProps": True,
            "File.ImportGroups": True,
            "__Focus": True,
        }
        link_manager.link.Load(params)

        return {"FINISHED"}
