"""Quit RizomUV remotely."""

from typing import TYPE_CHECKING

import bpy
from bpy.types import Context

from rizomuv_bridge_link.data import constants
from rizomuv_bridge_link.functions.rizomuv_link import rizomuv_link_manager

if TYPE_CHECKING:
    from rizomuv_bridge_link.preferences import RizomUVBridgePreferences


class RizomQuit(bpy.types.Operator):
    """Quit RizomUV."""

    bl_description = "Quit Rizom"
    bl_idname = "ruv_link.rizom_quit"
    bl_label = "Quit (RizomUV)"
    bl_options = {"REGISTER", "INTERNAL"}

    def __init__(self):
        self.prefs: "RizomUVBridgePreferences" = bpy.context.preferences.addons[constants.PACKAGE_NAME].preferences

    def execute(self, context: Context) -> set[str]:
        """Execute the operator.

        Args:
            context: Current data context.

        Returns:
            Enum in {'RUNNING_MODAL', 'CANCELLED', 'FINISHED', 'PASS_THROUGH'}
        """

        link_manager = rizomuv_link_manager.RizomUVLinkManager(self.prefs.rizom_path)
        if not link_manager.connect_to_rizom():
            self.report({"ERROR"}, "You are not connected to an instance of RizomUV.")
            return {"CANCELLED"}

        link_manager.link.Quit()

        return {"FINISHED"}
