﻿/*
 * Created by SharpDevelop.
 * User: Admin
 * Date: 2023/10/25
 * Time: 10:51
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.IO;
using System.Text.RegularExpressions;
using System.Text;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using Microsoft.VisualBasic;

namespace mouyu
{
	/// <summary>
	/// Description of MainForm.
	/// </summary>
	public partial class MainForm : Form
	{
		[DllImport("user32.dll")]
		public static extern bool ReleaseCapture();
		[DllImport("user32.dll")]
		public static extern int SendMessage(IntPtr hWnd, int Msg, int wParam, int lParam); 
		 
		
		//隐藏滑动条
		   [DllImport("user32.dll", CharSet = CharSet.Auto)]
        public static extern int ShowScrollBar(IntPtr hWnd, int bar, int show);


        private class SubWindow : NativeWindow
        {
            private int m_Horz = 0;
            private int m_Show = 0;

            public SubWindow(int p_Horz, int p_Show)
            {
                m_Horz = p_Horz;
                m_Show = p_Show;
            }
            protected override void WndProc(ref Message m_Msg)
            {
                ShowScrollBar(m_Msg.HWnd, m_Horz, m_Show);
                base.WndProc(ref m_Msg);
            }
        }

        /// <summary>
        /// 设置滚动条是否显示  zgke@sina.com qq:116149
        /// </summary>
        /// <param name="p_ControlHandle">句柄</param>
        /// <param name="p_Horz">0横 1列 3全部</param>
        /// <param name="p_Show">0隐 1显</param>
        public static void SetScrollBar(IntPtr p_ControlHandle, int p_Horz, int p_Show)
        {
            SubWindow _SubWindow = new SubWindow(p_Horz, p_Show);
            _SubWindow.AssignHandle(p_ControlHandle);
        }
        
         
	
		public MainForm()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			richTextBoxTM1.AllowDrop = true;
            richTextBoxTM1.DragEnter += new DragEventHandler(richTextBox1_DragEnter);
            richTextBoxTM1.DragDrop += new DragEventHandler(richTextBox1_DragDrop);
         //   richTextBoxTM1.MouseWheel+=new MouseEventHandler(richTextBox1_MouseWheel);
         SetScrollBar(this.richTextBoxTM1.Handle,3, 0);
//            this.BackColor =Color.White;
//            this.TransparencyKey = Color.White;
		//	LoadChapter("1.txt");
				TopLevel=true;
			TopMost=true;

			this.BackColor = Color.LightSlateGray;
            this.TransparencyKey =this.BackColor;
            
            LoadRememberedTxt();//自动加载上次打开的txt文件
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
		}
		 
		 
		private void richTextBox1_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                e.Effect = DragDropEffects.Link;
            }
            else
            {
                e.Effect = DragDropEffects.None;
            }
        }
 
        private void richTextBox1_DragDrop(object sender, DragEventArgs e)
        {
            string file = ((System.Array)e.Data.GetData(DataFormats.FileDrop)).GetValue(0).ToString();//获得路径
            if (File.Exists(file))
            {
                string Extension = System.IO.Path.GetExtension(file).ToLower();
                if (Extension == ".txt")
                {
                    this.Text = System.IO.Path.GetFileName(file);
                    this.richTextBoxTM1.LoadFile(file, RichTextBoxStreamType.PlainText);//读取txt文件
                   RememberTxt(file);//记录txt文件的路径
                    LoadChapter(file);//读取章节
                   DeleteBookmark();//删除书签(防止打开B小说，却加载了A小说书签的bug)
                }
            }
            
            
        }
		
		 //读取章节
        public void LoadChapter(string file)
        {
        	//contentsToolStripMenuItem.DropDownItems.Clear();
            try
            {
              //  this.listBox1.Items.Clear();
                if (File.Exists(file))
                {
                    FileStream fs = new FileStream(file, FileMode.Open);
                    using (StreamReader sr = new StreamReader(fs, System.Text.Encoding.Default))
                    {
                        string strLine = sr.ReadLine(); //读取文件中的一行
                        string t="";
                        while (strLine != null)
                        {
                        	
                            string[] patArr = { "第(.*?)章", "第(.*?)回", "第(.*?)集", "第(.*?)卷", "第(.*?)部", "第(.*?)篇", "第(.*?)节", "第(.*?)季" };
                            foreach (var pattern in patArr)
                            {
                                Regex reg = new Regex(pattern);
                                if (reg.IsMatch(strLine))
                                {
                                    if (strLine.Length < 20)//超过20个字的标题，可能是小说里面出现的“书中书、文中文”...
                                    {
                                    	t=strLine.Trim().Replace("\r\n", "").Replace("\r", "").Replace("\n", "");
                                    	 
						                ToolStripItem fd = contentsToolStripMenuItem.DropDownItems.Add(t);
						
						                fd.Click += new System.EventHandler(contentsToolStripMenuItem_Click);
                                       // this.listBox1.Items.Add(strLine.Trim().Replace("\r\n", "").Replace("\r", "").Replace("\n", ""));//添加标题行
                                    }
                                    continue;
                                }                             
                            }
                            strLine = sr.ReadLine();
                            //Thread.Sleep(1);
                        }
                       // MessageBox.Show(t);
                    }
                }
            }
            catch { }
        }
        private void contentsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            String name = ((ToolStripMenuItem)sender).Text;
            FindTags(name);
        }
		void MainFormDragEnter(object sender, DragEventArgs e)
		{
			string file = ((System.Array)e.Data.GetData(DataFormats.FileDrop)).GetValue(0).ToString();//获得路径
            if (File.Exists(file))
            {
                string Extension = System.IO.Path.GetExtension(file).ToLower();
                if (Extension == ".txt")
                {
                    this.Text = System.IO.Path.GetFileName(file);
                    this.richTextBoxTM1.LoadFile(file, RichTextBoxStreamType.PlainText);//读取txt文件
                 //   RememberTxt(file);//记录txt文件的路径
                    LoadChapter(file);//读取章节
                  //  DeleteBookmark();//删除书签(防止打开B小说，却加载了A小说书签的bug)
                }
            }
		}
		//跳转书签，章节
		private void FindTags(string name)
        {
            try
            {
                if (!string.IsNullOrEmpty(name) && !string.IsNullOrWhiteSpace(name))
                {
                    richTextBoxTM1.Focus();
                    richTextBoxTM1.Find(name);
                    richTextBoxTM1.ScrollToCaret();
                }
            }
            catch { }
        }
		void ExitToolStripMenuItemClick(object sender, EventArgs e)
		{
			//FindTags("闺房的窗子是开着的");
			this.Close();
			 
		}
		
		private const int VM_NCLBUTTONDOWN_ = 0XA1; //VM_NCLBUTTONDOWN //定义鼠标左键按下
private const int HTCAPTION_ = 2; // HTCAPTION

 
		void RichTextBoxTM1MouseDown(object sender, MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Left)
            {
				 
                //这里一定要判断鼠标左键按下状态，否则会出现一个很奇葩的BUG，不信邪可以试一下~~
                ReleaseCapture();
                SendMessage(Handle, 0x00A1, 2, 0);
              //   SendMessage(this.Handle, VM_NCLBUTTONDOWN_, HTCAPTION_, 0);
			}
		}
		public string BaseDirectory = System.AppDomain.CurrentDomain.BaseDirectory + "ini/";//配置文件所在路径
		void BookmarkToolStripMenuItemClick(object sender, EventArgs e)
		{
			if (richTextBoxTM1.SelectedText != "")
            {
                string shu = StrTooLong(richTextBoxTM1.SelectedText.Trim());
//                FileStream fs = new FileStream(BaseDirectory + "bookmark.txt", FileMode.Create);
//                StreamWriter sw = new StreamWriter(fs);
//                sw.Write(shu);
//                sw.Close();
//                fs.Close();
                
                if (!File.Exists(BaseDirectory + "bookmark.txt"))
            {
                FileStream fs = new FileStream(BaseDirectory + "bookmark.txt", FileMode.Create, FileAccess.Write);
                StreamWriter sw = new StreamWriter(fs);
                sw.WriteLine(shu);
                //记得要关闭！不然里面没有字！
                sw.Close();
                fs.Close();
            }
            else
            {  
                StreamWriter sw = File.AppendText(BaseDirectory + "bookmark.txt");
                sw.WriteLine(shu);
                sw.Close();
                 
            }
                MessageBox.Show("书签已经存储！！");
               // bMToolStripMenuItem.DropDownItems.Clear();
                ToolStripItem fd = bMToolStripMenuItem.DropDownItems.Add(shu);

                fd.Click += new System.EventHandler(dsToolStripMenuItem_Click);
            }
		}
		//点击书签 定位到书签位置
        private void dsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            String name = ((ToolStripMenuItem)sender).Text;
            FindTags(name);
        }
		//控制标签字符串长度为10个字
        private string StrTooLong(string str)
        {
            string temp = str.Replace(" ", "|").Replace("\r\n", "|").Replace("\r", "|").Replace("\n", "|");
            string[] arr = temp.Split('|');
            string shu = "";
            foreach (var item in arr)
            {
                if (!string.IsNullOrEmpty(item.Trim()))
                {
                    if (item.Length <= 10)
                    {
                        shu = item;
                    }
                    else
                    {
                        shu = item.Substring(0, 10);
                    }
                    break;
                }
            }
            return shu;
        }
		  
		//加载书签
        private void LoadBookmark()
        {
            bMToolStripMenuItem.DropDownItems.Clear();

            string file = BaseDirectory + "bookmark.txt";
            if (File.Exists(file))
            {
            	string[] line =File.ReadAllLines(file);
            	for (int i = 0; i < line.Length; i++) {
            		string shu=line[i];
                        if (!string.IsNullOrEmpty(shu) && !string.IsNullOrWhiteSpace(shu))
                        {
                            ToolStripItem fd = bMToolStripMenuItem.DropDownItems.Add(shu);
                            fd.Click += new System.EventHandler(dsToolStripMenuItem_Click);
                        }
            	}
            }
        }
        //删除书签
        private void DeleteBookmark()
        {
            try
            {
                bMToolStripMenuItem.DropDownItems.Clear();

                string file = BaseDirectory + "bookmark.txt";
                if (File.Exists(file))
                {
                    File.Delete(file);
                }
            }
            catch { }
        } 
		 //记录上一次打开txt文件的路径，这样在下一次运行时直接调用此路径，不用再次手动选择txt文件，除非txt文件位置或文件名发生改变
        private void RememberTxt(string txt)
        {
            try
            {
                if (!string.IsNullOrEmpty(txt) && !string.IsNullOrWhiteSpace(txt))
                {
                    FileStream fs = new FileStream(BaseDirectory + "my.txt", FileMode.Create);
                    using (StreamWriter sw = new StreamWriter(fs))
                    {
                        sw.WriteLine(txt);
                        sw.Close();
                        fs.Close();
                    }
                }
            }
            catch { }
        }
        //载入图书(自动)
        private void LoadRememberedTxt()
        {
            try
            {
                string file = BaseDirectory + "my.txt";
                if (File.Exists(file))
                {
                    FileStream fs = new FileStream(file, FileMode.Open);//打开保存记录的文件
                    using (StreamReader sr = new StreamReader(fs))
                    {
                        String fileName = sr.ReadLine();//读取txt打开记录
                        if (!string.IsNullOrEmpty(fileName) && !string.IsNullOrWhiteSpace(fileName))//判断是否有记录
                        {
                            if (File.Exists(fileName))//判断是否有文件
                            {
                                this.Text = System.IO.Path.GetFileName(fileName);
                                this.richTextBoxTM1.LoadFile(fileName, RichTextBoxStreamType.PlainText);//读取txt文件
                                LoadChapter(fileName);//读取章节
                            }
                        }
                        sr.Close();
                        fs.Close();
                    }
                    LoadBookmark();//加载书签
                }
            }
            catch { }
        }
		void MainFormActivated(object sender, EventArgs e)
		{
			 HotKey.RegisterHotKey(Handle, 100, HotKey.KeyModifiers.Alt, Keys.W);//注册热键 Alt+1 老板键 我用着顺手
			 HotKey.RegisterHotKey(Handle, 200, HotKey.KeyModifiers.Alt, Keys.E); //显示
			 HotKey.RegisterHotKey(Handle, 300, HotKey.KeyModifiers.Alt, Keys.Q); //退出
			 HotKey.RegisterHotKey(Handle, 400,HotKey.KeyModifiers.None, Keys.CapsLock); //翻页
		}
		void MainFormLeave(object sender, EventArgs e)
		{
			HotKey.UnregisterHotKey(Handle, 100);//注销Id号为100的热键设定
		}
		 //执行热键
        protected override void WndProc(ref Message m)
        {
            const int WM_HOTKEY = 0x0312;
            //按快捷键 
            switch (m.Msg)
            {
                case WM_HOTKEY:
                    switch (m.WParam.ToInt32())
                    {
                        case 100://按下的是Alt+1 
                            BossKey();//老板键
                            break;
                        case 200://按下的是Alt+1 
                            richTextBoxTM1.Visible=true;
                            break; 
                        case 300://按下的是Alt+1 
                            this.Close();
                            break; 
                         case 400://按下的是Alt+1 
                            SendKeys.Send("{PGDN}");
                            break; 
                    }
                    break;
            }
            base.WndProc(ref m);
        }
        //老板键：显示|隐藏 窗体
        private void BossKey()
        {
            if (this.WindowState == FormWindowState.Normal)
            {
                this.WindowState = FormWindowState.Minimized;
                this.Hide();//隐藏窗体
                this.notifyIcon1.Visible = true; //使托盘图标可见
            }
            else
            {
                this.Visible = true;
                this.WindowState = FormWindowState.Normal;
                this.notifyIcon1.Visible = false;
            }
        }
		void FontToolStripMenuItemClick(object sender, EventArgs e)
		{
			fontDialog1.ShowDialog();
            richTextBoxTM1.Font = fontDialog1.Font;
		}
		void ColorToolStripMenuItemClick(object sender, EventArgs e)
		{
			 colorDialog1.ShowDialog();
            richTextBoxTM1.ForeColor = colorDialog1.Color;
		}
		void SizeToolStripMenuItemClick(object sender, EventArgs e)
		{
			try {
				string str =Interaction.InputBox("输入w,h", "调整边框大小", Width.ToString()+","+this.Height.ToString());
			//MessageBox.Show(str);
			string[] wh=str.Split(',');
			this.Width=int.Parse(wh[0]);
			this.Height=int.Parse(wh[1]);
			} catch (Exception) {
				
				 
			}
		}
		int n=0;
		bool flag=false;
		void HideToolStripMenuItemClick(object sender, EventArgs e)
		{
			if (n%2==0) {
				hideToolStripMenuItem.Text="鼠标离开隐藏on";
				flag=true;
				
			}else{
				hideToolStripMenuItem.Text="鼠标离开隐藏off";
				flag=false;
			}
			n++;
		}
		void RichTextBoxTM1MouseHover(object sender, EventArgs e)
		{
			if (flag) {
				richTextBoxTM1.Visible=true;
			}
		}
		void RichTextBoxTM1MouseLeave(object sender, EventArgs e)
		{
			if (flag) {
				richTextBoxTM1.Visible=false;}
		}
		void ExitToolStripMenuItem1Click(object sender, EventArgs e)
		{
			this.Close();
		}
		void OpenToolStripMenuItemClick(object sender, EventArgs e)
		{
			OpenFileDialog openFileDialog=new OpenFileDialog();
		    openFileDialog.InitialDirectory="c:\\";//注意这里写路径时要用c:\\而不是c:\
		    openFileDialog.Filter="TXT小说|*.txt|所有文件|*.*";
		    openFileDialog.RestoreDirectory=true;
		    openFileDialog.FilterIndex=1;
		    if (openFileDialog.ShowDialog()==DialogResult.OK)
		    {
		        
		        this.richTextBoxTM1.LoadFile(openFileDialog.FileName, RichTextBoxStreamType.PlainText);//读取txt文件
		        RememberTxt(openFileDialog.FileName);//记录txt文件的路径
                    LoadChapter(openFileDialog.FileName);//读取章节
                   DeleteBookmark();//删除书签(防止打开B小说，却加载了A小说书签的bug)                        
		    }
		}
		void HelpToolStripMenuItemClick(object sender, EventArgs e)
		{
			MessageBox.Show("Alt+Q退出程序\nAlt+W老板键\nAlt+E显示\npagedown翻页");
		}
		 
		
		public void RememberHistory(){
			try
            {
				int start = richTextBoxTM1.GetCharIndexFromPosition(new Point(0, 0));
				int end = richTextBoxTM1.GetCharIndexFromPosition(new Point(richTextBoxTM1.ClientSize.Width, richTextBoxTM1.ClientSize.Height-1));
				var displayedText = richTextBoxTM1.Text.Substring(start,end-start);
				string txt=StrTooLong(displayedText);
				
                if (!string.IsNullOrEmpty(txt) && !string.IsNullOrWhiteSpace(txt))
                {
                    FileStream fs = new FileStream(BaseDirectory + "History.txt", FileMode.Create);
                    using (StreamWriter sw = new StreamWriter(fs))
                    {
                    	
                        sw.WriteLine(txt);
                        sw.Close();
                        fs.Close();
                    }
                }
            }
            catch { }
		}
		void MainFormFormClosing(object sender, FormClosingEventArgs e)
		{
			RememberHistory();
		}
		void HistoryToolStripMenuItemClick(object sender, EventArgs e)
		{
			string file = BaseDirectory + "History.txt";
                if (File.Exists(file))
                {
                	string[] txt=File.ReadAllLines(file);
                	//MessageBox.Show(txt);
                	FindTags(txt[0]);
                }
			
		}
		void OpenutfToolStripMenuItemClick(object sender, EventArgs e)
		{
			OpenFileDialog openFileDialog=new OpenFileDialog();
		    openFileDialog.InitialDirectory="c:\\";//注意这里写路径时要用c:\\而不是c:\
		    openFileDialog.Filter="TXT小说|*.txt|所有文件|*.*";
		    openFileDialog.RestoreDirectory=true;
		    openFileDialog.FilterIndex=1;
		    if (openFileDialog.ShowDialog()==DialogResult.OK)
		    {
		        FileStream fs = new FileStream(openFileDialog.FileName, FileMode.Open, FileAccess.Read);
				StreamReader sr = new StreamReader(fs, Encoding.UTF8);
				//utf-8转Unicode
				byte[] buffer = Encoding.Convert(Encoding.UTF8, Encoding.Unicode, Encoding.UTF8.GetBytes(sr.ReadToEnd()));
				//将byte[]转换位内存流
				Stream stream = new MemoryStream(buffer);
				//RichTextBoxStreamType.UnicodePlainText 加载
				richTextBoxTM1.LoadFile(stream, RichTextBoxStreamType.UnicodePlainText);
				
				fs.Close();
				sr.Close();
				stream.Close();
				
				RememberTxt(openFileDialog.FileName);//记录txt文件的路径
                    LoadChapter(openFileDialog.FileName);//读取章节
                   DeleteBookmark();//删除书签(防止打开B小说，却加载了A小说书签的bug)   
		      //  this.richTextBoxTM1.LoadFile(openFileDialog.FileName, RichTextBoxStreamType.PlainText);//读取txt文件
		                                
		    }
		}
		
	}   //改变窗体大小 https://juejin.cn/post/7137689694510743582
	//utf乱码 https://www.cnblogs.com/SunSpring/p/17585574.html
		 
}
